%% load data

load MSCI_data
warning off all

d=5;  %dimension to consider

%r=1;  %forecast horizon (may be used later)
%compute returns
Y=(log(data(2:end,:))-log(data(1:end-1,:)))*100;   
Y_full=Y(:,1:d);



%to store the results
Tests_N=[];
Tests_KS=[];
Tests_K=[];
Per_tests_N=[];
Per_tests_KS=[];
Per_tests_K=[];


for period=9
%period of choice
if period==1
    first=835;
    last=1043;
elseif period==2
    first=1044;
    last=1252;
elseif period==3
    first=1253;
    last=1460;    
elseif period==4
    first=1461;
    last=1669;
elseif period==5
    first=1670;
    last=1878;       
elseif period==6
    first=1879;
    last=2087;    
elseif period==7
    first=2088;
    last=2295;
elseif period==8
    first=2296;
    last=2504;
elseif period==9   %this case is for the full-sample analysis
    first=835;
    last=2504;    
end  
    
    
    
    
%sample size, in-sample and out-of-sample
Y=Y_full(first-521:last,:);  %10-years for model estimation
T=size(Y,1);
Toos=last-first+1;     %always 4 years out-of-sample data
T_is=T-Toos;

%Y=Y-kron(mean(Y),ones(T,1));  %demean (how to handle OOS data in this?)

%% Estimate and forecast the covariance matrix

scores_oos=zeros(Toos,3*d+2);  %to safe the scores

Sigma=zeros(d,d,Toos);   %initialize the covariance matrix for forecasts
for k=1:Toos  
    Y_is=Y(1:(T_is+k-1),:);
    Y_is=Y_is-repmat(mean(Y_is),T_is+k-1,1);
    %Y_is=Y(1+k-1:(T_is+k-1),:);   %the in-sample data
    garchparam=zeros(d,3);
    [parameters, loglikelihood, Ht, Rt]=dcc_mvgarch(Y_is,1,1,1,1);
    parameters_all=parameters;
    for i=1:d
        garchparam(i,:)=parameters(3*i-2:3*i);
    end;
    dccparam=parameters(3*d+1:3*d+2);
    ht1=zeros(T_is+k,d);
    %obtain 1-step forecasts  (for multi-step forecasts use code from 'forecast_script_DCC')
    for i=1:d
        ht1(:,i)=garchcore([Y_is(1:end,i)' Y(T_is+k,i)]',garchparam(i,:)',5,1,1,1,T_is+k);
    end;
    [logL, Rt1, likelihoods, Qt, Rbar]=dcc_mvgarch_full_likelihood(parameters, [Y_is(1:end,:)' Y(T_is+k,:)']', ones(1,d),ones(1,d),1,1);%don't forget to add Qbar to the output of the called function
    D=diag(sqrt(ht1(end,:)));
    R=Rt1(:,:,end);
    Sigma(:,:,k)=D*R*D;
    
    
    %now compute the scores
    scoretmp=[];
for j=1:d
Data=[Y_is(1:end,j)' Y(T_is+k,j)]';
stdEstimate =  std(Data,1);  
%Data        =  [stdEstimate(ones(1,1)) ; Data]; 
T=size(Data,1);
t=T-1;

parameters=garchparam(j,:)';
h=max(abs(parameters/2),1e-2)*eps^(1/3);
   hplus=parameters+h;
   hminus=parameters-h;
   likelihoodsplus=zeros(t,length(parameters));
   likelihoodsminus=zeros(t,length(parameters));
   for i=1:length(parameters)
      hparameters=parameters;
      hparameters(i)=hplus(i);
      [HOLDER, HOLDER1, indivlike] = fattailed_garchlikelihood(hparameters,Data,1,1,1, stdEstimate^2, T);
      likelihoodsplus(:,i)=indivlike;
   end
   for i=1:length(parameters)
      hparameters=parameters;
      hparameters(i)=hminus(i);
      [HOLDER, HOLDER1, indivlike] = fattailed_garchlikelihood(hparameters,Data,1,1,1, stdEstimate^2, T);
      likelihoodsminus(:,i)=indivlike;
   end
   scores=(likelihoodsplus-likelihoodsminus)./(2*repmat(h',t,1));
   scores=scores-repmat(mean(scores),t,1);
   
       
scoretmp=[scoretmp scores(end,:)];
end;     

% Now the DCC part
parameters=parameters_all;
data=[Y_is(1:end,:)' Y(T_is+k,:)']';
 h=max(abs(parameters/2),1e-2)*eps^(1/3);
    hplus=parameters+h;
    hminus=parameters-h;
    likelihoodsplus=zeros(T,length(parameters));
    likelihoodsminus=zeros(T,length(parameters));
    for i=length(parameters)-1-1+1:length(parameters)
        hparameters=parameters;
        hparameters(i)=hplus(i);
        [HOLDER, HOLDER1, indivlike] = dcc_mvgarch_full_likelihood(hparameters, data, ones(1,d),ones(1,d),1,1);
        likelihoodsplus(:,i)=indivlike;
    end
    for i=length(parameters)-1-1+1:length(parameters)
        hparameters=parameters;
        hparameters(i)=hminus(i);
        [HOLDER, HOLDER1, indivlike] = dcc_mvgarch_full_likelihood(hparameters, data, ones(1,d),ones(1,d),1,1);
        likelihoodsminus(:,i)=indivlike;
    end
    DCCscores=(likelihoodsplus(:,length(parameters)-1-1+1:length(parameters))-likelihoodsminus(:,length(parameters)-1-1+1:length(parameters)))...
        ./(2*repmat(h(length(parameters)-1-1+1:length(parameters))',T,1));






scoretmp=[scoretmp DCCscores(end,:)];


 
scores_oos(k,:)=scoretmp; 
end; 
    
    
    




%}
%% density forecast evaluation
Y_oos=Y(end-Toos+1:end,:);

%PITs for each week
P=zeros(Toos,1);
P_star=zeros(Toos,1);
U_DHT=[];
Z2=zeros(Toos,1);
U_Z2_star=zeros(Toos,1);
U_Z2_dag=zeros(Toos,1);

%first just perform all test before trying all permutations (which are
%362880 different ones for d=9)!!!)
parfor t=1:Toos  
    Sigma0=Sigma(:,:,t);   %covariance for that week
    
    
    %the easy part: CS, KP and DHT
    U=normcdf(Y_oos(t,1)/sqrt(Sigma0(1,1)));  %PIT
    P(t)=U;
    P_star(t)=(U-0.5);
    U_DHT=[U_DHT U];
    Z2(t)=norminv(U).^2;
    for i=2:d
        
        Sigma_ii=Sigma0(i,i);
        Sigma_ij=Sigma0(i,1:i-1);
        Sigma_jj=Sigma0(1:i-1,1:i-1);
        V= Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  %variance of the transformed variable
        Uij=normcdf((Y_oos(t,i)- (Sigma_ij*inv(Sigma_jj)*Y_oos(t,1:i-1)')')/sqrt(V));
        Uij(Uij<0.0000001)=0.0000001;  %black monday observation causes numerical problems
        U=[U Uij];
        P(t)=P(t).*Uij;
        P_star(t)=P_star(t).*(Uij-0.5);
        U_DHT=[U_DHT Uij]; 
        Z2(t)=Z2(t)+norminv(Uij).^2;
        
    end
    
    %Z2_star and Z2_dag are outsourced to another function (needs to be
    %done every period due to dependence)
    U_Z2_star(t)=PIT_Z2star(Y_oos(t,:),Sigma0);
    U_Z2_dag(t)=PIT_Z2dag(Y_oos(t,:),Sigma0);
    
end

U_Z2=chi2cdf(Z2,d);

%PIT for Clements-Smith and Ko-Park
U_CS=CS_PIT(P,d);
U_KP=KP_PIT(P_star,d);

U_DHT=U_DHT';  %make row vector as input for other functions

lambda=Toos/T_is; 
[P_Z2_star]= NST_EU_DM(U_Z2_star,scores_oos',lambda,2);
[P_Z2_dag]= NST_EU_DM(U_Z2_dag,scores_oos',lambda,2);
[P_Z2]= NST_EU_DM(U_Z2,scores_oos',lambda,2);
[P_CS]= NST_EU_DM(U_CS,scores_oos',lambda,2);
[P_KP]= NST_EU_DM(U_KP,scores_oos',lambda,2);
[P_DHT]= NST_EU_DM(U_DHT,repmat(scores_oos',1,d),lambda*d,2);

Tests_N=[Tests_N; P_DHT P_CS P_KP P_Z2 P_Z2_star P_Z2_dag]



%% Now try all permutations

D=(1:d);
Perm = perms(D);  %all possible permutations (gets very large for large d, do not use d>10, best only up to d=8 -> 40320 permutations)
K=size(Perm,1);

Pvals=zeros(K,3);  %store the p-values here
Pvals_K=zeros(K,3); 
    


for k=1:K  %go through all permutations of the data

P=zeros(Toos,1);
P_star=zeros(Toos,1);
U_DHT=[];

X=Y_oos(:,Perm(k,:));
parfor t=1:Toos
    Sigma0=Sigma(Perm(k,:),Perm(k,:),t);   %covariance for that week
    
    
    %the easy part: CS, KP and DHT
    U=normcdf(X(t,1)/sqrt(Sigma0(1,1)));  %PIT
    P(t)=U;
    P_star(t)=(U-0.5);
    U_DHT=[U_DHT U];
    Z2(t)=norminv(U).^2;
    for i=2:d
        
        Sigma_ii=Sigma0(i,i);
        Sigma_ij=Sigma0(i,1:i-1);
        Sigma_jj=Sigma0(1:i-1,1:i-1);
        V= Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  %variance of the transformed variable
        Uij=normcdf((X(t,i)- (Sigma_ij*inv(Sigma_jj)*X(t,1:i-1)')')/sqrt(V));
        Uij(Uij<0.0000001)=0.0000001;
        U=[U Uij];
        P(t)=P(t).*Uij;
        P_star(t)=P_star(t).*(Uij-0.5);
        U_DHT=[U_DHT Uij]; 
              
    end

end

U_DHT=U_DHT';

U_CS=CS_PIT(P,d);
U_KP=KP_PIT(P_star,d);
[Pvals(k,1)]= NST_EU_DM(U_DHT,repmat(scores_oos',1,d),lambda*d,2);
[Pvals(k,2)]= NST_EU_DM(U_CS,scores_oos',lambda,2);
[Pvals(k,3)]= NST_EU_DM(U_KP,scores_oos',lambda,2);



end

Per_tests_N=[Per_tests_N; min(Pvals(:,1)) max(Pvals(:,1)) mean(Pvals(:,1)>0.05) ...
    min(Pvals(:,2)) max(Pvals(:,2)) mean(Pvals(:,2)>0.05) min(Pvals(:,3)) max(Pvals(:,3)) mean(Pvals(:,3)>0.05) ]



end